# Generated by Django 2.2.19 on 2022-03-17 10:59

from django.db import migrations


def migrate_fk(apps, schema_editor):
    '''Replace wcs_form_api_url by uuid in child models.'''
    WcsRequest = apps.get_model('toulouse_smart', 'WcsRequest')
    WcsRequestFile = apps.get_model('toulouse_smart', 'WcsRequestFile')
    SmartRequest = apps.get_model('toulouse_smart', 'SmartRequest')
    wcs_form_api_url_to_uuid = dict(WcsRequest.objects.values_list('wcs_form_api_url', 'uuid'))

    for wcs_request_file in WcsRequestFile.objects.all():
        wcs_request_file.resource_new_id = wcs_form_api_url_to_uuid[wcs_request_file.resource]
        wcs_request_file.save(update_fields=['resource_new_id'])

    for smart_request in SmartRequest.objects.all():
        smart_request.resource_new_id = wcs_form_api_url_to_uuid[smart_request.resource]
        smart_request.save(update_fields=['resource_new_id'])


class Migration(migrations.Migration):
    dependencies = [
        ('toulouse_smart', '0008_recreate_wscrequest_fk'),
    ]

    operations = [
        migrations.RunPython(migrate_fk, migrations.RunPython.noop),
    ]
