from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ('base', '0002_auto_20151009_0326'),
    ]

    operations = [
        migrations.CreateModel(
            name='APIParticulier',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(verbose_name='Identifier', unique=True)),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'log_level',
                    models.CharField(
                        default=b'NOTSET',
                        max_length=10,
                        verbose_name='Log Level',
                        choices=[
                            (b'NOTSET', b'NOTSET'),
                            (b'DEBUG', b'DEBUG'),
                            (b'INFO', b'INFO'),
                            (b'WARNING', b'WARNING'),
                            (b'ERROR', b'ERROR'),
                            (b'CRITICAL', b'CRITICAL'),
                        ],
                    ),
                ),
                (
                    '_platform',
                    models.CharField(
                        choices=[(b'prod', 'Production'), (b'test', 'Test')],
                        max_length=8,
                        verbose_name='Platform',
                    ),
                ),
                (
                    '_api_key',
                    models.CharField(default=b'', max_length=64, verbose_name='API key', blank=True),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        to='base.ApiUser',
                        related_name='_apiparticulier_users_+',
                        related_query_name='+',
                        blank=True,
                    ),
                ),
            ],
            options={
                'abstract': False,
                'verbose_name': 'API Particulier',
            },
            bases=(models.Model,),
        ),
    ]
