# Copyright (C) 2021  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pytest
from httmock import HTTMock, response, urlmatch

from . import utils


class TestBdp:
    @pytest.fixture
    def connector(self, db):
        from passerelle.apps.bdp.models import Bdp

        return utils.setup_access_rights(
            Bdp.objects.create(
                slug='slug',
                service_url='https://bdp.example.com',
                username='username',
                password='password',
            )
        )

    def test_detail_view(self, app, connector):
        @urlmatch(netloc=r'^bdp.example.com$', path=r'^/api/coin')
        def api_coin(url, request):
            return response(
                200,
                [
                    {
                        'id': 'id',
                        'text': 'coin',
                    }
                ],
            )

        with HTTMock(api_coin):
            resp = app.get('/bdp/slug/coin/')
            assert resp.json['data']
