# Generated by Django 2.2.19 on 2022-03-23 12:09

import django.contrib.postgres.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='Holidays',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'zone',
                    models.CharField(
                        choices=[('a', 'A'), ('b', 'B'), ('c', 'C')], max_length=16, verbose_name='Zone'
                    ),
                ),
                (
                    'holidays',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(
                            choices=[
                                ('winter_holidays', 'Vacances d’Hiver'),
                                ('spring_holidays', 'Vacances de Pâques'),
                                ('summer_holidays', 'Vacances d’Été'),
                                ('all_saints_holidays', 'Vacances de la Toussaint'),
                                ('christmas_holidays', 'Vacances de Noël'),
                                ('fathers_day', 'Fête des Pères'),
                                ('mothers_day', 'Fête des Mères'),
                            ],
                            max_length=32,
                        ),
                        size=None,
                        verbose_name='Holidays',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_holidays_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'School holidays',
            },
        ),
    ]
