# Generated by Django 1.11.18 on 2019-12-06 11:44

import django.db.models.deletion
from django.db import migrations, models

import passerelle.apps.base_adresse.models


class Migration(migrations.Migration):
    dependencies = [
        ('base_adresse', '0014_auto_20190207_0456'),
    ]

    operations = [
        migrations.CreateModel(
            name='CityModel',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.CharField(max_length=150, verbose_name='City name')),
                (
                    'unaccent_name',
                    models.CharField(max_length=150, null=True, verbose_name='City name ascii char'),
                ),
                ('code', models.CharField(max_length=5, verbose_name='INSEE code')),
                ('zipcode', models.CharField(max_length=5, verbose_name='Postal code')),
                ('population', models.PositiveIntegerField(verbose_name='Population')),
                ('last_update', models.DateTimeField(auto_now=True, null=True, verbose_name='Last update')),
            ],
            options={
                'ordering': ['-population', 'zipcode', 'unaccent_name', 'name'],
            },
            bases=(passerelle.apps.base_adresse.models.UnaccentNameMixin, models.Model),
        ),
        migrations.CreateModel(
            name='DepartmentModel',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.CharField(max_length=100, verbose_name='Department name')),
                (
                    'unaccent_name',
                    models.CharField(max_length=150, null=True, verbose_name='Department name ascii char'),
                ),
                ('code', models.CharField(max_length=3, unique=True, verbose_name='Department code')),
                ('last_update', models.DateTimeField(auto_now=True, null=True, verbose_name='Last update')),
            ],
            options={
                'ordering': ['code'],
            },
            bases=(passerelle.apps.base_adresse.models.UnaccentNameMixin, models.Model),
        ),
        migrations.CreateModel(
            name='RegionModel',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.CharField(max_length=150, verbose_name='Region name')),
                (
                    'unaccent_name',
                    models.CharField(max_length=150, null=True, verbose_name='Region name ascii char'),
                ),
                ('code', models.CharField(max_length=2, unique=True, verbose_name='Region code')),
                ('last_update', models.DateTimeField(auto_now=True, null=True, verbose_name='Last update')),
            ],
            options={
                'ordering': ['code'],
            },
            bases=(passerelle.apps.base_adresse.models.UnaccentNameMixin, models.Model),
        ),
        migrations.AddField(
            model_name='baseadresse',
            name='api_geo_url',
            field=models.CharField(
                default=b'https://geo.api.gouv.fr/',
                help_text='Base Adresse API Geo URL',
                max_length=128,
                verbose_name='API Geo URL',
            ),
        ),
        migrations.AlterField(
            model_name='baseadresse',
            name='zipcode',
            field=models.CharField(
                blank=True,
                max_length=600,
                verbose_name='Postal codes or department number to get streets, separated with commas',
            ),
        ),
        migrations.AlterField(
            model_name='streetmodel',
            name='city',
            field=models.CharField(max_length=150, verbose_name='City'),
        ),
        migrations.AddField(
            model_name='departmentmodel',
            name='region',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to='base_adresse.RegionModel'
            ),
        ),
        migrations.AddField(
            model_name='citymodel',
            name='department',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='base_adresse.DepartmentModel',
            ),
        ),
        migrations.AddField(
            model_name='citymodel',
            name='region',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='base_adresse.RegionModel',
            ),
        ),
        migrations.AlterUniqueTogether(
            name='citymodel',
            unique_together={('code', 'zipcode')},
        ),
    ]
