# Generated by Django 1.11.20 on 2019-06-19 10:24

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0012_job'),
    ]

    operations = [
        migrations.CreateModel(
            name='AstreGS',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('wsdl_base_url', models.URLField(verbose_name='Webservices base URL')),
                ('username', models.CharField(max_length=32, verbose_name='Username')),
                ('password', models.CharField(max_length=32, verbose_name='Password')),
                ('organism', models.CharField(max_length=32, verbose_name='Organisme')),
                ('budget', models.CharField(max_length=32, verbose_name='Budget')),
                ('exercice', models.CharField(max_length=32, verbose_name='Exercice')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True, related_name='_astregs_users_+', related_query_name='+', to='base.ApiUser'
                    ),
                ),
            ],
            options={
                'verbose_name': 'AstresGS',
            },
        ),
        migrations.CreateModel(
            name='Link',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name_id', models.CharField(max_length=32)),
                ('association_id', models.CharField(max_length=32)),
                ('created', models.DateTimeField(auto_now_add=True)),
                (
                    'resource',
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='astregs.AstreGS'),
                ),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='link',
            unique_together={('resource', 'name_id', 'association_id')},
        ),
    ]
