# Generated by Django 1.11.15 on 2018-11-19 15:27

from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0009_auto_20181118_0807'),
    ]

    operations = [
        migrations.CreateModel(
            name='PlanitechConnector',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True)),
                (
                    'url',
                    models.URLField(
                        help_text='URL of the Planitech API endpoint',
                        max_length=400,
                        verbose_name='Planitech API endpoint',
                    ),
                ),
                ('username', models.CharField(max_length=128, verbose_name='Service username')),
                (
                    'password',
                    models.CharField(blank=True, max_length=128, null=True, verbose_name='Service password'),
                ),
                (
                    'verify_cert',
                    models.BooleanField(default=True, verbose_name='Check HTTPS Certificate validity'),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_planitechconnector_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Planitech',
            },
        ),
    ]
