# Generated by Django 1.11.18 on 2020-03-04 10:25

import uuid

import django.db.models.deletion
from django.db import migrations, models

import passerelle.apps.cryptor.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('base', '0016_auto_20191002_1443'),
    ]

    operations = [
        migrations.CreateModel(
            name='CryptedFile',
            fields=[
                (
                    'uuid',
                    models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ('filename', models.CharField(max_length=512)),
                ('content_type', models.CharField(max_length=128)),
                ('creation_timestamp', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Cryptor',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'public_key',
                    models.TextField(
                        blank=True,
                        validators=[passerelle.apps.cryptor.models.validate_rsa_key],
                        verbose_name='Encryption RSA public key (PEM format)',
                    ),
                ),
                (
                    'private_key',
                    models.TextField(
                        blank=True,
                        validators=[passerelle.apps.cryptor.models.validate_rsa_key],
                        verbose_name='Decryption RSA private key (PEM format)',
                    ),
                ),
                (
                    'redirect_url_base',
                    models.URLField(
                        blank=True,
                        help_text='Base URL for redirect, empty for local',
                        max_length=256,
                        verbose_name='Base URL of decryption system',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True, related_name='_cryptor_users_+', related_query_name='+', to='base.ApiUser'
                    ),
                ),
            ],
            options={
                'verbose_name': 'Encryption / Decryption',
            },
        ),
        migrations.AddField(
            model_name='cryptedfile',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='cryptor.Cryptor'),
        ),
    ]
