# Generated by Django 2.2.19 on 2021-08-15 19:40

import django.db.models.deletion
from django.db import migrations, models

import passerelle.apps.sector.models
import passerelle.utils.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='Sector',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=256, verbose_name='Title')),
                ('slug', models.CharField(max_length=128, verbose_name='Identifier')),
            ],
            options={
                'ordering': ['resource', 'slug'],
            },
        ),
        migrations.CreateModel(
            name='SectorResource',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'csv_file',
                    models.FileField(
                        help_text='CSV file',
                        upload_to=passerelle.utils.models.resource_file_upload_to,
                        verbose_name='Sectorization file',
                    ),
                ),
                (
                    'titles_in_first_line',
                    models.BooleanField(
                        default=True,
                        help_text='Sinon, les colonnes sont\xa0: street_id,street_name,parity,min_housenumber,max_housenumber,sector_id,sector_name…',
                        verbose_name='First line defines column titles',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_sectorresource_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'verbose_name': 'Sectorization',
            },
        ),
        migrations.CreateModel(
            name='Sectorization',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('street_id', models.CharField(max_length=64, verbose_name='Street Identifier')),
                (
                    'parity',
                    models.SmallIntegerField(
                        choices=[(0, 'all'), (1, 'odd'), (2, 'even')],
                        default=0,
                        verbose_name='Parity of numbers',
                    ),
                ),
                (
                    'min_housenumber',
                    models.PositiveIntegerField(default=0, verbose_name='Minimum house number (included)'),
                ),
                (
                    'max_housenumber',
                    models.PositiveIntegerField(
                        default=999999, verbose_name='Maximum house number (included)'
                    ),
                ),
                (
                    'sector',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to='sector.Sector', verbose_name='Sector'
                    ),
                ),
            ],
            options={
                'ordering': ['street_id', 'min_housenumber', 'parity'],
            },
        ),
        migrations.AddField(
            model_name='sector',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sector.SectorResource'),
        ),
        migrations.AlterUniqueTogether(
            name='sector',
            unique_together={('resource', 'slug')},
        ),
    ]
