# Generated by Django 1.11.20 on 2019-09-19 15:23

import django.contrib.postgres.fields.jsonb
import django.db.models.deletion
from django.db import migrations, models

import passerelle.utils.sftp


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0014_auto_20190820_0914'),
    ]

    operations = [
        migrations.CreateModel(
            name='Form',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('form_id', models.CharField(max_length=64)),
                ('creation_datetime', models.DateTimeField(auto_now_add=True)),
                ('filename', models.CharField(max_length=128, null=True)),
                (
                    'status',
                    models.CharField(
                        choices=[(b'new', b'New'), (b'sent', b'Sent'), (b'closed', b'Closed')],
                        default=b'new',
                        max_length=8,
                    ),
                ),
                ('demand_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('card_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
            ],
            options={
                'get_latest_by': 'creation_datetime',
            },
        ),
        migrations.CreateModel(
            name='Gesbac',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                (
                    'outcoming_sftp',
                    passerelle.utils.sftp.SFTPField(default=None, verbose_name='Outcoming SFTP'),
                ),
                (
                    'incoming_sftp',
                    passerelle.utils.sftp.SFTPField(default=None, verbose_name='Incoming SFTP'),
                ),
                ('output_files_prefix', models.CharField(max_length=32, verbose_name='Output files prefix')),
                ('input_files_prefix', models.CharField(max_length=32, verbose_name='Input files prefix')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True, related_name='_gesbac_users_+', related_query_name='+', to='base.ApiUser'
                    ),
                ),
            ],
            options={
                'verbose_name': 'Gesbac',
            },
        ),
        migrations.AddField(
            model_name='form',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gesbac.Gesbac'),
        ),
    ]
