# Generated by Django 2.2.26 on 2022-10-14 10:35

from django.conf import settings
from django.db import migrations, models


def get_csv_columns_from_old_settings(setting_name):
    def func():
        columns = getattr(settings, setting_name, [])
        lines = []
        for column in columns:
            try:
                name, title = column
                line = f'{name} {title}'
            except ValueError:
                line = column
            lines.append(line)
        return '\n'.join(lines)

    return func


class Migration(migrations.Migration):

    dependencies = [
        ('rsa13', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='rsa13resource',
            name='beneficiaire_csv_columns',
            field=models.TextField(
                blank=True,
                verbose_name='CSV columns for beneficiaires',
                default=get_csv_columns_from_old_settings('RSA13_CSV_COLUMNS'),
            ),
        ),
        migrations.AddField(
            model_name='rsa13resource',
            name='facturation_csv_columns',
            field=models.TextField(
                blank=True,
                verbose_name='CSV columns for facturation',
                default=get_csv_columns_from_old_settings('RSA13_FACTURATION_CSV_COLUMNS'),
            ),
        ),
        migrations.AddField(
            model_name='rsa13resource',
            name='sorti_csv_columns',
            field=models.TextField(
                blank=True,
                verbose_name='CSV columns for sorti',
                default=get_csv_columns_from_old_settings('RSA13_BENEFICIAIRE_SORTI_CSV_COLUMNS'),
            ),
        ),
        migrations.AlterField(
            model_name='rsa13resource',
            name='beneficiaire_csv_columns',
            field=models.TextField(blank=True, verbose_name='CSV columns for beneficiaires'),
        ),
        migrations.AlterField(
            model_name='rsa13resource',
            name='facturation_csv_columns',
            field=models.TextField(blank=True, verbose_name='CSV columns for facturation'),
        ),
        migrations.AlterField(
            model_name='rsa13resource',
            name='sorti_csv_columns',
            field=models.TextField(blank=True, verbose_name='CSV columns for sorti'),
        ),
    ]
