# Generated by Django 2.2.26 on 2022-07-11 14:30

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='ToulouseMaelis',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'basic_auth_username',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication username'
                    ),
                ),
                (
                    'basic_auth_password',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication password'
                    ),
                ),
                (
                    'client_certificate',
                    models.FileField(
                        blank=True, null=True, upload_to='', verbose_name='TLS client certificate'
                    ),
                ),
                (
                    'trusted_certificate_authorities',
                    models.FileField(blank=True, null=True, upload_to='', verbose_name='TLS trusted CAs'),
                ),
                (
                    'verify_cert',
                    models.BooleanField(blank=True, default=True, verbose_name='TLS verify certificates'),
                ),
                (
                    'http_proxy',
                    models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy'),
                ),
                (
                    'base_wsdl_url',
                    models.CharField(
                        default='https://demo-toulouse.sigec.fr/maelisws-toulouse/services/',
                        max_length=128,
                        verbose_name='URL de base des WSDL',
                    ),
                ),
                (
                    'zeep_wsse_username',
                    models.CharField(
                        blank=True, default='', max_length=64, verbose_name='Identifiant utilisateur WSSE'
                    ),
                ),
                (
                    'zeep_wsse_password',
                    models.CharField(blank=True, default='', max_length=64, verbose_name='Mot de passe WSSE'),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_toulousemaelis_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Toulouse Maelis',
            },
        ),
        migrations.CreateModel(
            name='Link',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name_id', models.CharField(max_length=256)),
                ('family_id', models.CharField(max_length=128)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to='toulouse_maelis.ToulouseMaelis'
                    ),
                ),
            ],
            options={
                'unique_together': {('resource', 'name_id')},
            },
        ),
    ]
