# Generated by Django 1.11.18 on 2020-05-15 17:28

import django.db.models.deletion
from django.db import migrations, models

import passerelle.utils.templates


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0020_auto_20200515_1923'),
    ]

    operations = [
        migrations.CreateModel(
            name='OpenDataSoft',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'service_url',
                    models.CharField(
                        help_text='OpenData Web Service URL', max_length=256, verbose_name='Service URL'
                    ),
                ),
                (
                    'api_key',
                    models.CharField(
                        blank=True,
                        help_text='API key used as credentials',
                        max_length=128,
                        verbose_name='API key',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_opendatasoft_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'OpenDataSoft Web Service',
            },
        ),
        migrations.CreateModel(
            name='Query',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('slug', models.SlugField(max_length=128, verbose_name='Slug')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                (
                    'dataset',
                    models.CharField(help_text='dataset to query', max_length=128, verbose_name='Dataset'),
                ),
                (
                    'text_template',
                    models.TextField(
                        blank=True,
                        help_text="Use Django's template syntax. Attributes can be accessed through {{ attributes.name }}",
                        validators=[passerelle.utils.templates.validate_template],
                        verbose_name='Text template',
                    ),
                ),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='queries',
                        to='opendatasoft.OpenDataSoft',
                        verbose_name='Resource',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Query',
                'ordering': ['name'],
                'abstract': False,
            },
        ),
        migrations.AlterUniqueTogether(
            name='query',
            unique_together={('resource', 'slug'), ('resource', 'name')},
        ),
    ]
