# passerelle - uniform access to multiple data sources and services
# Copyright (C) 2015  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.urls import re_path

from passerelle.contrib.fake_family import views

urlpatterns = [
    re_path(r'^(?P<slug>[\w,-]+)/$', views.FakeFamilyDetailView.as_view(), name='fake-family-view'),
    re_path(r'^(?P<slug>[\w,-]+)/dump/$', views.DumpView.as_view(), name='fake-family-dump'),
    re_path(r'^(?P<slug>[\w,-]+)/family/link/$', views.LinkView.as_view(), name='fake-family-link'),
    re_path(r'^(?P<slug>[\w,-]+)/family/unlink/$', views.UnlinkView.as_view(), name='fake-family-unlink'),
    re_path(r'^(?P<slug>[\w,-]+)/family/$', views.FamilyView.as_view(), name='fake-family-info'),
    re_path(
        r'^(?P<slug>[\w,-]+)/family/(?P<key>[\w,-]+)/$', views.FamilyKeyView.as_view(), name='fake-family-key'
    ),
]
