# Generated by Django 2.2.24 on 2022-01-19 16:37

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='SOAPConnector',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'basic_auth_username',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication username'
                    ),
                ),
                (
                    'basic_auth_password',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication password'
                    ),
                ),
                (
                    'client_certificate',
                    models.FileField(
                        blank=True, null=True, upload_to='', verbose_name='TLS client certificate'
                    ),
                ),
                (
                    'trusted_certificate_authorities',
                    models.FileField(blank=True, null=True, upload_to='', verbose_name='TLS trusted CAs'),
                ),
                (
                    'verify_cert',
                    models.BooleanField(blank=True, default=True, verbose_name='TLS verify certificates'),
                ),
                (
                    'http_proxy',
                    models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy'),
                ),
                (
                    'wsdl_url',
                    models.URLField(
                        help_text='URL of the WSDL file', max_length=400, verbose_name='WSDL URL'
                    ),
                ),
                (
                    'zeep_strict',
                    models.BooleanField(default=True, verbose_name='Be strict with returned XML'),
                ),
                (
                    'zeep_xsd_ignore_sequence_order',
                    models.BooleanField(default=False, verbose_name='Ignore sequence order'),
                ),
                (
                    'zeep_wsse_username',
                    models.CharField(max_length=256, blank=True, default='', verbose_name='WSSE Username'),
                ),
                (
                    'zeep_wsse_password',
                    models.CharField(max_length=256, blank=True, default='', verbose_name='WSSE Password'),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_soapconnector_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'SOAP connector',
            },
        ),
    ]
