from django.urls import re_path
from django.views.decorators.csrf import csrf_exempt

from .views import BdpDetailView, PostAdherentView, ResourcesView

urlpatterns = [
    re_path(r'^(?P<slug>[\w,-]+)/$', BdpDetailView.as_view(), name='bdp-view'),
    re_path(r'^(?P<slug>[\w,-]+)/(?P<resources>[\w,-]+)/$', ResourcesView.as_view(), name='bdp-resources'),
    re_path(
        r'^(?P<slug>[\w,-]+)/post/adherent/$',
        csrf_exempt(PostAdherentView.as_view()),
        name='bdp-post-adherent',
    ),
]
