# Generated by Django 2.2.24 on 2022-04-19 13:14

import django.contrib.postgres.fields.jsonb
import django.db.models.deletion
from django.db import migrations, models

import passerelle.contrib.toulouse_foederis.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'basic_auth_username',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication username'
                    ),
                ),
                (
                    'basic_auth_password',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication password'
                    ),
                ),
                (
                    'client_certificate',
                    models.FileField(
                        blank=True, null=True, upload_to='', verbose_name='TLS client certificate'
                    ),
                ),
                (
                    'trusted_certificate_authorities',
                    models.FileField(blank=True, null=True, upload_to='', verbose_name='TLS trusted CAs'),
                ),
                (
                    'verify_cert',
                    models.BooleanField(blank=True, default=True, verbose_name='TLS verify certificates'),
                ),
                (
                    'http_proxy',
                    models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy'),
                ),
                ('url', models.URLField(verbose_name='Webservice Base URL')),
                ('api_key', models.CharField(max_length=512, verbose_name='API Key')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_resource_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Foederis connector',
                'verbose_name_plural': 'Foederis connectors',
            },
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('external_id', models.CharField(max_length=64, unique=True, verbose_name='Key')),
                ('text', models.CharField(max_length=64, null=True, verbose_name='Text')),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(null=True, verbose_name='Data')),
                (
                    'pdf',
                    models.FileField(
                        upload_to=passerelle.contrib.toulouse_foederis.models.upload_to,
                        verbose_name='PDF file',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='documents',
                        to='toulouse_foederis.Resource',
                        verbose_name='Resource',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Foederis data',
                'verbose_name_plural': 'Foederis datas',
            },
        ),
    ]
