# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2020-07-15 08:33
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0022_auto_20200715_1033'),
    ]

    operations = [
        migrations.CreateModel(
            name='TwilioSMSGateway',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'default_country_code',
                    models.CharField(
                        default='33',
                        max_length=3,
                        verbose_name='Default country code',
                        validators=[
                            django.core.validators.RegexValidator(
                                '^[0-9]*$', 'The country must only contain numbers'
                            )
                        ],
                    ),
                ),
                (
                    'default_trunk_prefix',
                    models.CharField(
                        default='0',
                        max_length=2,
                        verbose_name='Default trunk prefix',
                        validators=[
                            django.core.validators.RegexValidator(
                                '^[0-9]*$', 'The trunk prefix must only contain numbers'
                            )
                        ],
                    ),
                ),
                (
                    'max_message_length',
                    models.IntegerField(
                        help_text='Messages over this limit will be truncated.',
                        default=2000,
                        verbose_name='Maximum message length',
                    ),
                ),
                ('account_sid', models.CharField(max_length=64, verbose_name='Account Sid')),
                ('auth_token', models.CharField(max_length=64, verbose_name='Auth Token')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='_twiliosmsgateway_users_+',
                        related_query_name='+',
                        to='base.ApiUser',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Twilio',
                'db_table': 'sms_twilio',
            },
        ),
    ]
