# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-08-06 10:42
from __future__ import unicode_literals

import uuid

import django.contrib.postgres.fields.jsonb
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('toulouse_smart', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='WcsRequest',
            fields=[
                ('wcs_form_api_url', models.CharField(max_length=256, primary_key=True, serialize=False)),
                ('wcs_form_number', models.CharField(max_length=16)),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('payload', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('result', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                (
                    'status',
                    models.CharField(
                        choices=[('registered', 'Registered'), ('sent', 'Sent')],
                        default='registered',
                        max_length=20,
                    ),
                ),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='wcs_requests',
                        to='toulouse_smart.ToulouseSmartResource',
                    ),
                ),
            ],
        ),
        migrations.AlterField(
            model_name='cache',
            name='resource',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='cache_entries',
                to='toulouse_smart.ToulouseSmartResource',
                verbose_name='Resource',
            ),
        ),
    ]
