# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2021-03-01 14:52
from __future__ import unicode_literals

from django.db import migrations, models

import passerelle.apps.esirius.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0029_auto_20210202_1627'),
    ]

    operations = [
        migrations.CreateModel(
            name='ESirius',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'basic_auth_username',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication username'
                    ),
                ),
                (
                    'basic_auth_password',
                    models.CharField(
                        blank=True, max_length=128, verbose_name='Basic authentication password'
                    ),
                ),
                (
                    'client_certificate',
                    models.FileField(
                        blank=True, null=True, upload_to='', verbose_name='TLS client certificate'
                    ),
                ),
                (
                    'trusted_certificate_authorities',
                    models.FileField(blank=True, null=True, upload_to='', verbose_name='TLS trusted CAs'),
                ),
                ('verify_cert', models.BooleanField(default=True, verbose_name='TLS verify certificates')),
                (
                    'http_proxy',
                    models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy'),
                ),
                (
                    'secret_id',
                    models.CharField(blank=True, max_length=128, verbose_name='Application identifier'),
                ),
                (
                    'secret_key',
                    passerelle.apps.esirius.models.DESKeyModel(
                        blank=True, max_length=128, verbose_name='Secret Key'
                    ),
                ),
                (
                    'base_url',
                    models.CharField(
                        help_text='example: https://HOST/ePlanning/webservices/api/',
                        max_length=256,
                        verbose_name='ePlanning webservices URL',
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True, related_name='_esirius_users_+', related_query_name='+', to='base.ApiUser'
                    ),
                ),
            ],
            options={
                'verbose_name': 'eSirius',
            },
        ),
    ]
