# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2020-04-06 15:02
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('csvdatasource', '0015_query_slug_unicity'),
    ]

    operations = [
        migrations.AlterField(
            model_name='csvdatasource',
            name='columns_keynames',
            field=models.CharField(
                blank=True,
                default='id, text',
                help_text='ex: id,text,data1,data2',
                max_length=256,
                verbose_name='Column keynames',
            ),
        ),
        migrations.AlterField(
            model_name='csvdatasource',
            name='csv_file',
            field=models.FileField(
                help_text='Supported file formats: csv, ods, xls, xlsx',
                upload_to='csv',
                verbose_name='Spreadsheet file',
            ),
        ),
        migrations.AlterField(
            model_name='query',
            name='resource',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='queries',
                to='csvdatasource.CsvDataSource',
            ),
        ),
        migrations.AlterField(
            model_name='query',
            name='structure',
            field=models.CharField(
                choices=[
                    ('array', 'Array'),
                    ('dict', 'Dictionary'),
                    ('keyed-distinct', 'Keyed Dictionary'),
                    ('tuples', 'Tuples'),
                    ('onerow', 'Single Row'),
                    ('one', 'Single Value'),
                ],
                default='dict',
                help_text='Data structure used for the response',
                max_length=20,
                verbose_name='Structure',
            ),
        ),
    ]
