# -*- coding: utf-8 -*-

from io import BytesIO

import pytest
from django.core.files import File
from django.core.management import call_command
from django.db import connection

from passerelle.apps.csvdatasource.models import CsvDataSource
from passerelle.contrib.teamnet_axel.models import TeamnetAxel

pytestmark = pytest.mark.django_db


@pytest.fixture
def setup():
    def maker(
        columns_keynames='fam,id,lname,fname,sex', filename='data.csv', sheet_name='Feuille2', data=b''
    ):
        csv = CsvDataSource.objects.create(
            csv_file=File(BytesIO(data), filename),
            sheet_name=sheet_name,
            columns_keynames=columns_keynames,
            slug='test',
            title='a title',
            description='a description',
        )
        teamnet = TeamnetAxel.objects.create(
            slug='test', billing_regies={}, wsdl_url='http://example.net/AXEL_WS/AxelWS.php?wsdl'
        )
        return csv, teamnet

    return maker


def test_ensure_jsonb_fields(setup):
    with connection.cursor() as cursor:
        query = "SELECT table_name, column_name, data_type FROM information_schema.columns WHERE column_name IN ('_dialect_options', 'billing_regies')"
        cursor.execute(query)

        # make sure the data_type is correct
        for line in cursor.fetchall():
            assert line[2] == 'jsonb'

        # alter columns
        cursor.execute(
            'ALTER TABLE csvdatasource_csvdatasource ALTER COLUMN _dialect_options TYPE text USING _dialect_options::text'
        )
        cursor.execute(
            'ALTER TABLE teamnet_axel_teamnetaxel ALTER COLUMN billing_regies TYPE text USING billing_regies::text'
        )

    call_command('ensure_jsonb')

    with connection.cursor() as cursor:
        query = "SELECT table_name, column_name, data_type FROM information_schema.columns WHERE column_name IN ('_dialect_options', 'billing_regies')"
        cursor.execute(query)

        # check the data_type is correct
        for line in cursor.fetchall():
            assert line[2] == 'jsonb'
