# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-09-29 13:56
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0022_auto_20200715_1033'),
    ]

    operations = [
        migrations.CreateModel(
            name='Link',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name_id', models.CharField(max_length=256)),
                ('family_id', models.CharField(max_length=128)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Maelis',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'base_url',
                    models.URLField(
                        default='http://www3.sigec.fr/entrouvertws/services/', verbose_name='Base API URL'
                    ),
                ),
                ('login', models.CharField(max_length=256, verbose_name='API Login')),
                ('password', models.CharField(max_length=256, verbose_name='API Password')),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True, related_name='_maelis_users_+', related_query_name='+', to='base.ApiUser'
                    ),
                ),
            ],
            options={
                'verbose_name': 'Maélis',
            },
        ),
        migrations.AddField(
            model_name='link',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='maelis.Maelis'),
        ),
        migrations.AlterUniqueTogether(
            name='link',
            unique_together=set([('resource', 'name_id')]),
        ),
    ]
