from django.conf.urls import url
from django.views.decorators.csrf import csrf_exempt

from passerelle.apps.clicrdv import views

urlpatterns = [
    url(r'^(?P<slug>[\w,-]+)/$', views.ClicRdvDetailView.as_view(), name='clicrdv-view'),
    url(
        r'^(?P<slug>[\w,-]+)/interventions/(?P<intervention_id>\d+)/datetimes/$',
        views.DateTimesView.as_view(),
        name='clicrdv-datetimes',
    ),
    url(
        r'^(?P<slug>[\w,-]+)/interventions/(?P<intervention_id>\d+)/dates/$',
        views.DatesView.as_view(),
        name='clicrdv-dates',
    ),
    url(
        r'^(?P<slug>[\w,-]+)/interventions/(?P<intervention_id>\d+)/(?P<date>[\d-]+)/times$',
        views.TimesView.as_view(),
        name='clicrdv-times',
    ),
    url(
        r'^(?P<slug>[\w,-]+)/interventions/(?P<intervention_id>\d+)/create$',
        csrf_exempt(views.CreateAppointmentView.as_view()),
        name='clicrdv-create-appointment',
    ),
    url(
        r'^(?P<slug>[\w,-]+)/create$',
        csrf_exempt(views.CreateAppointmentView.as_view()),
        name='clicrdv-create-appointment-qs',
    ),
    url(
        r'^(?P<slug>[\w,-]+)/(?P<appointment_id>\d+)/cancel$',
        views.CancelAppointmentView.as_view(),
        name='clicrdv-cancel-appointment',
    ),
]
