# passerelle - uniform access to multiple data sources and services
# Copyright (C) 2019 Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.contrib import admin
from django.utils.html import format_html

from .models import Request


class RequestAdmin(admin.ModelAdmin):
    date_hierarchy = 'created'
    search_fields = ['url', 'filename']
    list_display = ['id', 'created', 'modified', 'state', 'filename', 'form_url']

    def form_url(self, obj):
        return format_html('<a href="{0}">{0}</a>', obj.url)

    form_url.allow_tags = True


admin.site.register(Request, RequestAdmin)
