# passerelle - uniform access to multiple data sources and services
# Copyright (C) 2021  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.apps import AppConfig


def add_logging_to_cmislib():
    '''Monkeypatch cmislib request module to log requests and responses.'''

    from cmislib.atompub import binding
    from cmislib.net import RESTService

    class RESTService(RESTService):
        def get(self, url, *args, **kwargs):
            logger = kwargs.pop('passerelle_logger')
            logger.debug('cmislib GET request to %s', url)
            resp, content = super().get(url, *args, **kwargs)
            logger.debug('cmislib GET response (%s)', resp['status'], extra={'response': content.decode()})
            return resp, content

        def delete(self, url, *args, **kwargs):
            logger = kwargs.pop('passerelle_logger')
            logger.debug('cmislib DELETE request to %s', url)
            resp, content = super().delete(url, *args, **kwargs)
            logger.debug('cmislib DELETE response (%s)', resp['status'], extra={'response': content.decode()})
            return resp, content

        def post(self, url, payload, *args, **kwargs):
            logger = kwargs.pop('passerelle_logger')
            logger.debug('cmislib POST request to %s', url, extra={'payload': payload.decode()})
            resp, content = super().post(url, payload, *args, **kwargs)
            logger.debug('cmislib POST response (%s)', resp['status'], extra={'response': content.decode()})
            return resp, content

        def put(self, url, payload, *args, **kwargs):
            logger = kwargs.pop('passerelle_logger')
            logger.debug('cmislib PUT request to %s', url, payload, extra={'payload': payload.decode()})
            resp, content = super().put(url, *args, **kwargs)
            logger.debug('cmislib PUT response (%s)', resp['status'], extra={'response': content.decode()})
            return resp, content

    binding.Rest = RESTService


class CmisAppConfig(AppConfig):
    name = 'passerelle.apps.cmis'

    def ready(self):
        add_logging_to_cmislib()
