# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2021-02-02 12:04
from __future__ import unicode_literals

import django.contrib.postgres.fields
from django.db import migrations, models

import passerelle.sms.models


class Migration(migrations.Migration):

    dependencies = [
        ('ovh', '0012_auto_20201027_1121'),
    ]

    operations = [
        migrations.AddField(
            model_name='ovhsmsgateway',
            name='allow_premium_rate',
            field=models.BooleanField(
                default=False,
                help_text='This option is only applyed to France mainland',
                verbose_name='Allow premium rate numbers',
            ),
        ),
        migrations.AddField(
            model_name='ovhsmsgateway',
            name='authorized',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[
                        ('fr-metro', 'France mainland (+33 [67])'),
                        ('fr-domtom', 'France DOM/TOM (+262, etc.)'),
                        ('be', 'Belgian (+32 4[5-9]) '),
                        ('all', 'All'),
                    ],
                    max_length=32,
                    null=True,
                ),
                default=passerelle.sms.models.authorized_default,
                size=None,
                verbose_name='Authorized Countries',
            ),
        ),
        migrations.AlterField(
            model_name='ovhsmsgateway',
            name='alert_emails',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.EmailField(blank=True, max_length=254),
                blank=True,
                null=True,
                size=None,
                verbose_name='Email addresses list to send credit alerts to, separated by comma',
            ),
        ),
    ]
