# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0004_auto_20170117_0326'),
    ]

    operations = [
        migrations.CreateModel(
            name='OpenGIS',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('title', models.CharField(verbose_name='Title', max_length=50)),
                ('slug', models.SlugField(verbose_name='Identifier', unique=True)),
                ('description', models.TextField(verbose_name='Description')),
                (
                    'log_level',
                    models.CharField(
                        default=b'NOTSET',
                        max_length=10,
                        verbose_name='Log Level',
                        choices=[
                            (b'NOTSET', b'NOTSET'),
                            (b'DEBUG', b'DEBUG'),
                            (b'INFO', b'INFO'),
                            (b'WARNING', b'WARNING'),
                            (b'ERROR', b'ERROR'),
                            (b'CRITICAL', b'CRITICAL'),
                        ],
                    ),
                ),
                ('service_root_url', models.URLField(max_length=256, verbose_name='Service Root URL')),
                ('query_layer', models.CharField(max_length=256, verbose_name='Query Layer')),
                (
                    'users',
                    models.ManyToManyField(
                        to='base.ApiUser', related_name='_opengis_users_+', related_query_name='+', blank=True
                    ),
                ),
            ],
            options={
                'verbose_name': 'OpenGIS',
            },
        ),
    ]
