from django.apps import apps
from django.contrib import messages
from django.utils.translation import ugettext_lazy as _
from django.views.generic import FormView

from passerelle.utils.jsonresponse import APIError
from passerelle.views import GenericConnectorMixin

from .forms import SmsTestSendForm


class SmsTestSendView(GenericConnectorMixin, FormView):
    template_name = 'passerelle/manage/messages_service_test_send.html'

    def get_form_class(self):
        return SmsTestSendForm

    def get_object(self):
        return self.model.objects.get(slug=self.kwargs['slug'])

    def get_success_url(self):
        connector = self.get_object()
        return connector.get_absolute_url()

    def form_valid(self, form):
        number = form.cleaned_data['number']
        sender = form.cleaned_data['sender']
        message = form.cleaned_data['message']
        connector = self.get_object()
        try:
            number = connector.clean_numbers([number])[0]
            connector.send_msg(
                text=message, sender=sender, destinations=[number], stop=False)
        except APIError as exc:
            messages.error(self.request, _('Sending SMS fails: %s' % exc))
        else:
            messages.success(self.request, _('An SMS was just sent'))
        return super(SmsTestSendView, self).form_valid(form)
