# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-09-18 09:42
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.contrib.postgres.fields.jsonb


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0006_resourcestatus'),
    ]

    operations = [
        migrations.CreateModel(
            name='Link',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_id', models.CharField(max_length=256, verbose_name='NameID')),
                ('id_per', models.CharField(max_length=64, verbose_name='ID Per')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('extra', django.contrib.postgres.fields.jsonb.JSONField(null=True, verbose_name='Anything')),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(verbose_name='Identifier', unique=True)),
                ('log_level', models.CharField(choices=[(b'NOTSET', b'NOTSET'), (b'DEBUG', b'DEBUG'), (b'INFO', b'INFO'), (b'WARNING', b'WARNING'), (b'ERROR', b'ERROR'), (b'CRITICAL', b'CRITICAL'), (b'FATAL', b'FATAL')], default=b'INFO', max_length=10, verbose_name='Log Level')),
                ('basic_auth_username', models.CharField(blank=True, max_length=128, verbose_name='Basic authentication username')),
                ('basic_auth_password', models.CharField(blank=True, max_length=128, verbose_name='Basic authentication password')),
                ('client_certificate', models.FileField(blank=True, null=True, upload_to=b'', verbose_name='TLS client certificate')),
                ('trusted_certificate_authorities', models.FileField(blank=True, null=True, upload_to=b'', verbose_name='TLS trusted CAs')),
                ('verify_cert', models.BooleanField(default=True, verbose_name='TLS verify certificates')),
                ('http_proxy', models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy')),
                ('webservice_base_url', models.URLField(verbose_name='Webservice Base URL')),
                ('cod_rgp', models.CharField(default=b'RGP_PUB', max_length=64, verbose_name='Code RGP')),
                ('users', models.ManyToManyField(blank=True, related_name='_link_users_+', related_query_name='+', to='base.ApiUser')),
            ],
            options={
                'verbose_name': 'ATOS Genesys',
            },
        ),
        migrations.AddField(
            model_name='link',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='atos_genesys.Resource'),
        ),
        migrations.AlterUniqueTogether(
            name='link',
            unique_together=set([('resource', 'name_id', 'id_per')]),
        ),
    ]
