# -*- coding: utf-8 -*-
# Generated by Django 1.11.12 on 2018-11-18 13:17
from __future__ import unicode_literals

from django.db import migrations


def set_logging_parameters(apps, schema_editor):
    LoggingParameters = apps.get_model('base', 'LoggingParameters')
    ContentType = apps.get_model('contenttypes', 'ContentType')
    for model in apps.get_models():
        if not hasattr(model, 'log_level'):
            continue
        content_type = ContentType.objects.get_for_model(model)
        for instance in model.objects.all():
            parameters, created = LoggingParameters.objects.get_or_create(
                resource_type=content_type, resource_pk=instance.id
            )
            parameters.log_level = instance.log_level
            if parameters.log_level == 'NOTSET':
                parameters.log_level = 'INFO'
            parameters.save()


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0007_loggingparameters'),
    ]

    operations = [
        migrations.RunPython(set_logging_parameters, migrations.RunPython.noop),
    ]
