# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='OxydSMSGateway',
            fields=[
                (
                    'id',
                    models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True),
                ),
                ('title', models.CharField(verbose_name='Title', max_length=50)),
                ('slug', models.SlugField(verbose_name='Identifier', unique=True)),
                ('description', models.TextField(verbose_name='Description')),
                ('username', models.CharField(max_length=64, verbose_name='Username')),
                ('password', models.CharField(max_length=64, verbose_name='Password')),
                (
                    'default_country_code',
                    models.CharField(default='33', max_length=3, verbose_name='Default country code'),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        to='base.ApiUser',
                        related_name='_oxydsmsgateway_users_+',
                        related_query_name='+',
                        blank=True,
                    ),
                ),
            ],
            options={
                'db_table': 'sms_oxyd',
                'verbose_name': 'Oxyd',
            },
            bases=(models.Model,),
        ),
    ]
