# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2020-04-08 09:54
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('opengis', '0006_auto_20181118_0807'),
    ]

    operations = [
        migrations.CreateModel(
            name='Query',
            fields=[
                (
                    'id',
                    models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
                ),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('slug', models.SlugField(max_length=128, verbose_name='Slug')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('typename', models.CharField(max_length=256, verbose_name='Feature type')),
                ('filter_expression', models.TextField(blank=True, verbose_name='XML filter')),
            ],
            options={
                'ordering': ['name'],
                'abstract': False,
            },
        ),
        migrations.AlterField(
            model_name='opengis',
            name='projection',
            field=models.CharField(
                choices=[
                    ('EPSG:2154', 'EPSG:2154 (Lambert-93)'),
                    ('EPSG:3857', 'EPSG:3857 (WGS 84 / Pseudo-Mercator)'),
                    ('EPSG:3945', 'EPSG:3945 (CC45)'),
                    ('EPSG:4326', 'EPSG:4326 (WGS 84)'),
                ],
                default='EPSG:3857',
                max_length=16,
                verbose_name='GIS projection',
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='resource',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='queries',
                to='opengis.OpenGIS',
                verbose_name='Resource',
            ),
        ),
        migrations.AlterUniqueTogether(
            name='query',
            unique_together=set([('resource', 'name'), ('resource', 'slug')]),
        ),
    ]
