# Passerelle - uniform access to data and services
# Copyright (C) 2015-2020  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django.views.decorators.csrf import csrf_exempt
from django.conf.urls import url
from .views import GdcDetailView, VoiesView, PostDemandeView, StatusView

urlpatterns = [
    url(r'^(?P<slug>[\w,-]+)/$', GdcDetailView.as_view(), name='gdc-view'),
    url(r'^(?P<slug>[\w,-]+)/voies/(?P<insee>\d+)$', VoiesView.as_view(), name='gdc-voies'),
    url(r'^(?P<slug>[\w,-]+)/post/demande$', csrf_exempt(PostDemandeView.as_view()), name='gdc-post'),
    url(r'^(?P<slug>[\w,-]+)/status/(?P<ref>\d+)', StatusView.as_view(), name='gdc-status'),
]
