from django.conf.urls import url

from .views import ApiUserCreateView, ApiUserUpdateView, ApiUserDeleteView, \
        ApiUserListView, AccessRightDeleteView, AccessRightCreateView, \
        LoggingParametersUpdateView, ManageAvailabilityView, ImportSiteView, \
        ExportSiteView

access_urlpatterns = [
    url(r'^$', ApiUserListView.as_view(), name='apiuser-list'),
    url(r'^add$', ApiUserCreateView.as_view(), name='apiuser-add'),
    url(r'^(?P<pk>[\w,-]+)/edit$', ApiUserUpdateView.as_view(), name='apiuser-edit'),
    url(r'^(?P<pk>[\w,-]+)/delete$', ApiUserDeleteView.as_view(), name='apiuser-delete'),

    url(r'^(?P<pk>[\w,-]+)/remove$', AccessRightDeleteView.as_view(),
        name='access-right-remove'),
    url(r'^accessright/add/(?P<resource_type>[\w,-]+)/(?P<resource_pk>[\w,-]+)/(?P<codename>[\w,-]+)/',
        AccessRightCreateView.as_view(), name='access-right-add'),
    url(r'logging/parameters/(?P<resource_type>[\w,-]+)/(?P<resource_pk>[\w,-]+)/$',
        LoggingParametersUpdateView.as_view(), name='logging-parameters'),
    url(r'manage/availability/(?P<resource_type>[\w,-]+)/(?P<resource_pk>[\w,-]+)/$',
        ManageAvailabilityView.as_view(), name='manage-availability')

]

import_export_urlpatterns = [
    url(r'^import$', ImportSiteView.as_view(), name='import-site'),
    url(r'^export$', ExportSiteView.as_view(), name='export-site'),
]
