# -*- coding: utf-8 -*-
# Generated by Django 1.11.17 on 2020-05-10 12:34
from __future__ import unicode_literals

from django.db import migrations, models


def create_indexing_template(apps, schema_editor):
    Query = apps.get_model('opengis', 'Query')
    for query in Query.objects.all():
        query.indexing_template = ' '.join(['{{ %s|default:"" }}' % x.strip() for x in query.index_properties.split(',') if x.strip()])
        query.save()


class Migration(migrations.Migration):

    dependencies = [
        ('opengis', '0011_text_to_jsonb'),
    ]

    operations = [
        migrations.AddField(
            model_name='query',
            name='indexing_template',
            field=models.TextField(blank=True, help_text='Template used to generate contents used in fulltext search.', verbose_name='Indexing template'),
        ),
        migrations.RunPython(create_indexing_template, lambda x, y: None),
    ]
