import requests
import uuid
from urllib.parse import urljoin

from django.conf import settings
from django.contrib import messages
from django.shortcuts import reverse
from django.utils.translation import ugettext_lazy as _
from django.views.generic.base import RedirectView

from .models import OVHSMSGateway


class RequestTokenView(RedirectView):
    def get_redirect_url(self, *args, **kwargs):
        connector = OVHSMSGateway.objects.get(slug=kwargs["slug"])

        request_id = uuid.uuid4()
        confirm_token_url = reverse('ovh-confirm-token', kwargs={'slug': connector.slug, 'uuid': request_id})
        data = {
            "accessRules": [
                {"method": "GET", "path": "/sms/%s/" % connector.account},
                {"method": "POST", "path": "/sms/%s/jobs/" % connector.account},
            ],
            "redirection": self.request.build_absolute_uri(confirm_token_url),
        }
        headers = {"X-Ovh-Application": connector.application_key}

        resp = requests.post('https://eu.api.ovh.com/1.0/auth/credential', json=data, headers=headers)
        result = resp.json()

        self.request.session['ovh-token-%s' % request_id] = result['consumerKey']
        return result['validationUrl']


class ConfirmTokenView(RedirectView):
    def get_redirect_url(self, *args, **kwargs):
        connector = OVHSMSGateway.objects.get(slug=kwargs["slug"])
        consumer_key = self.request.session.get('ovh-token-%s' % kwargs['uuid'])

        if consumer_key:
            connector.consumer_key = consumer_key
            connector.save()
            messages.success(self.request, _('Successfuly completed connector configuration.'))
        else:
            messages.warning(self.request, _('Could not complete connector configuration, please try again.'))

        return connector.get_absolute_url()
