# -*- coding: utf-8 -*-
# passerelle - uniform access to multiple data sources and services
# Copyright (C) 2020  Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import unicode_literals

from django.utils import timezone

datetime_format = '%d/%m/%Y %H:%M:%S'


def normalize_invoice(invoice):
    data = {
        'id': '%s-%s' % (invoice.numFamily, invoice.numInvoice),
        'display_id': str(invoice.numInvoice),
        'label': invoice.TTFInfo.libelle,
        'created': invoice.dateInvoice.strftime(datetime_format),
        'amount': invoice.amountInvoice - invoice.amountPaid,
        'paid': invoice.amountInvoice == invoice.amountPaid,
        'total_amount': invoice.amountInvoice,
        'pay_limit_date': invoice.dateDeadline.strftime(datetime_format),
        'has_pdf': bool(invoice.pdfName),
        'amount_paid': invoice.amountPaid
    }
    if invoice.amountInvoice == invoice.amountPaid:
        data.update({
            'amount': 0,
            'pay_limit_date': '',
            'online_payment': False
        })
    return data


def normalize_activity(activity):
    activity['id'] = activity['activityPortail']['idAct']
    activity['text'] = activity['activityPortail']['label']
    return activity


def normalize_person(person):
    person['id'] = person['num']
    person['text'] = '{} {}'.format(
                person['firstname'], person['lastname']).strip()
    return person


def get_default_school_year():
    now = timezone.now()
    if now.strftime('%m-%d') >= '07-31':
        return now.year
    else:
        return now.year - 1
