open_log_window = function(base_url, log_pk) {
    var url = base_url + log_pk + '/';
    var current_url = window.location;
    if (window.location.href == window.location.origin + base_url + '?log_id=' + log_pk) {
      // remove log_id from url on modal close if direct access to a log
      window.history.pushState({}, 'no log', base_url);
    }
    $.get(url,
        function(response) {
          var $dialog = $(response).dialog({
            modal: true,
            width: 'auto',
            open: function(event, ui) {
              window.history.pushState({'log_id': log_pk}, 'log id', base_url + '?log_id=' + log_pk);
            },
            close: function (event, ui) {
              window.history.back();
            }
          });
        });
};

$(function() {
  $('#logs tbody tr').on('click', function() {
    var base_url = $(this).parents('table.main').data('log-base-url');
    var log_pk = $(this).data('pk');
    open_log_window(base_url, log_pk);
  });
  $('#jobs tbody tr').on('click', function() {
    var base_url = $(this).parents('table.main').data('job-base-url');
    var job_pk = $(this).data('pk');
    var url = base_url + job_pk + '/';
    $.get(url,
        function(response) {
          var $dialog = $(response).dialog({modal: true, width: 'auto'});
        });
  });

  /* keep title/slug in sync,
     this code comes from wcs/qommon/static/js/qommon.admin.js
  */
  $('body').delegate('input[data-slug-sync]', 'input change paste',
        function() {
          var $slug_field = $(this).parents('form').find('[name=' + $(this).data('slug-sync') + ']');
          $slug_field.val($.slugify($(this).val()));
  });
});
