# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-04-19 17:15
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.contrib.postgres.fields.jsonb
import passerelle.apps.sp_fr.models
import passerelle.utils.sftp
import passerelle.utils.wcs


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0012_job'),
    ]

    operations = [
        migrations.CreateModel(
            name='Mapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('procedure', models.CharField(choices=[(b'DOC', 'Request for construction site opening'), (b'recensementCitoyen', 'Request for mandatory citizen census'), (b'depotDossierPACS', 'Pre-request for citizen solidarity pact')], max_length=32, unique=True, verbose_name='Procedure')),
                ('formdef', passerelle.utils.wcs.FormDefField(verbose_name='Formdef')),
                ('rules', django.contrib.postgres.fields.jsonb.JSONField(default=passerelle.apps.sp_fr.models.default_rule, verbose_name='Rules')),
            ],
            options={
                'verbose_name': 'MDEL mapping',
                'verbose_name_plural': 'MDEL mappings',
            },
        ),
        migrations.CreateModel(
            name='Request',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='Created')),
                ('filename', models.CharField(max_length=128, verbose_name='Identifier')),
                ('archive', models.FileField(max_length=256, upload_to=b'', verbose_name='Archive')),
                ('state', models.CharField(choices=[(b'received', 'Received'), (b'transfered', 'Transferred'), (b'error', 'Error'), (b'returned', 'Returned')], default=b'received', max_length=16, verbose_name='State')),
                ('url', models.URLField(blank=True, verbose_name='URL')),
            ],
            options={
                'verbose_name': 'MDEL request',
                'verbose_name_plural': 'MDEL requests',
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('input_sftp', passerelle.utils.sftp.SFTPField(default=None, null=True, verbose_name='Input SFTP URL')),
                ('output_sftp', passerelle.utils.sftp.SFTPField(default=None, null=True, verbose_name='Output SFTP URL')),
                ('users', models.ManyToManyField(blank=True, related_name='_resource_users_+', related_query_name='+', to='base.ApiUser')),
            ],
            options={
                'verbose_name': 'Service-Public.fr',
            },
        ),
        migrations.AddField(
            model_name='request',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sp_fr.Resource', verbose_name='Resource'),
        ),
        migrations.AddField(
            model_name='mapping',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='mappings', to='sp_fr.Resource', verbose_name='Resource'),
        ),
        migrations.AlterUniqueTogether(
            name='request',
            unique_together=set([('resource', 'filename')]),
        ),
    ]
