# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.contrib.postgres.fields.jsonb


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='FakeFamily',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(verbose_name='Title', max_length=50)),
                ('slug', models.SlugField(verbose_name='Identifier', unique=True)),
                ('description', models.TextField(verbose_name='Description')),
                ('jsondatabase', django.contrib.postgres.fields.jsonb.JSONField(default=dict, verbose_name='Fake Database (JSON)', blank=True)),
                ('users', models.ManyToManyField(to='base.ApiUser', related_name='_fakefamily_users_+', related_query_name='+', blank=True)),
            ],
            options={
                'verbose_name': 'Fake Family System',
            },
            bases=(models.Model,),
        ),
    ]
