# passerelle - uniform access to multiple data sources and services
# Copyright (C) 2019 Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from django import forms
from django.views.generic import UpdateView, CreateView, DeleteView

from passerelle.base.mixins import ResourceChildViewMixin

from . import models


class QueryForm(forms.ModelForm):
    class Meta:
        model = models.Query
        fields = '__all__'
        exclude = ['resource']


class QueryNew(ResourceChildViewMixin, CreateView):
    model = models.Query
    form_class = QueryForm

    def form_valid(self, form):
        form.instance.resource = self.resource
        return super(QueryNew, self).form_valid(form)

    def get_changed_url(self):
        return self.object.get_absolute_url()


class QueryEdit(ResourceChildViewMixin, UpdateView):
    model = models.Query
    form_class = QueryForm


class QueryDelete(ResourceChildViewMixin, DeleteView):
    model = models.Query
