from django.conf import settings
from django.conf.urls import include, url

from django.contrib import admin

from django.contrib.auth.decorators import login_required
from django.views.static import serve as static_serve

from .views import (HomePageView, ManageView, ManageAddView,
        GenericCreateConnectorView, GenericDeleteConnectorView,
        GenericEditConnectorView, GenericEndpointView, GenericConnectorView,
        GenericViewLogsConnectorView, GenericLogView, GenericExportConnectorView,
        login, logout, menu_json)
from .base.views import GenericViewJobsConnectorView, GenericJobView
from .urls_utils import decorated_includes, required, app_enabled, manager_required
from .base.urls import access_urlpatterns, import_export_urlpatterns
from .plugins import register_apps_urls

from passerelle.apps.pastell import urls as pastell_urls

admin.autodiscover()

urlpatterns = [
    url(r'^$', HomePageView.as_view(), name='homepage'),

    url(r'^manage/$', manager_required(ManageView.as_view()), name='manage-home'),
    url(r'^manage/menu.json$', manager_required(menu_json), name='menu-json'),
    url(r'^manage/add$', manager_required(ManageAddView.as_view()), name='add-connector'),

    url(r'^media/(?P<path>.*)$', login_required(static_serve), {
        'document_root': settings.MEDIA_ROOT,
    }),
    url(r'^admin/', admin.site.urls),

    url(r'^manage/access/',
        decorated_includes(manager_required, include(access_urlpatterns))),
    url(r'^manage/',
        decorated_includes(manager_required, include(import_export_urlpatterns))),
]

urlpatterns += required(
    app_enabled('pastell'), [
        url(r'^manage/pastell/',
            decorated_includes(manager_required, include(pastell_urls.management_urlpatterns))),
    ]
)

# add patterns from apps
urlpatterns = register_apps_urls(urlpatterns)

# add authentication patterns
urlpatterns += [
    url(r'^logout/$', logout, name='logout'),
    url(r'^login/$', login, name='auth_login'),
]

if 'mellon' in settings.INSTALLED_APPS:
    urlpatterns += [url(r'^accounts/mellon/', include('mellon.urls'))]


urlpatterns += [
    url(r'^manage/(?P<connector>[\w,-]+)/', decorated_includes(manager_required,
        include([
            url(r'^add$',
                GenericCreateConnectorView.as_view(), name='create-connector'),
            url(r'^(?P<slug>[\w,-]+)/delete$',
                GenericDeleteConnectorView.as_view(), name='delete-connector'),
            url(r'^(?P<slug>[\w,-]+)/edit$',
                GenericEditConnectorView.as_view(), name='edit-connector'),
            url(r'^(?P<slug>[\w,-]+)/logs/$',
                GenericViewLogsConnectorView.as_view(), name='view-logs-connector'),
            url(r'^(?P<slug>[\w,-]+)/logs/(?P<log_pk>\d+)/$',
                GenericLogView.as_view(), name='view-log'),
            url(r'^(?P<slug>[\w,-]+)/jobs/$',
                GenericViewJobsConnectorView.as_view(), name='view-jobs-connector'),
            url(r'^(?P<slug>[\w,-]+)/jobs/(?P<job_pk>\d+)/$',
                GenericJobView.as_view(), name='view-job'),
            url(r'^(?P<slug>[\w,-]+)/export$',
                GenericExportConnectorView.as_view(), name='export-connector'),
        ])))
]

urlpatterns += [
    url(r'^(?P<connector>[\w,-]+)/(?P<slug>[\w,-]+)/$',
        GenericConnectorView.as_view(), name='view-connector'),
    url(r'^(?P<connector>[\w,-]+)/(?P<slug>[\w,-]+)/(?P<endpoint>[\w,-]+)(?:/(?P<rest>.*))?$',
        GenericEndpointView.as_view(), name='generic-endpoint')
]

if settings.DEBUG and 'debug_toolbar' in settings.INSTALLED_APPS:
    import debug_toolbar
    urlpatterns = [
        url(r'^__debug__/', include(debug_toolbar.urls)),
    ] + urlpatterns

from django.contrib.staticfiles.urls import staticfiles_urlpatterns
urlpatterns += staticfiles_urlpatterns()
