from django import forms
from django.utils.translation import ugettext_lazy as _

from .models import ApiUser, AccessRight, AvailabilityParameters


class ApiUserForm(forms.ModelForm):
    class Meta:
        model = ApiUser
        exclude = []


class AccessRightForm(forms.ModelForm):
    class Meta:
        model = AccessRight
        exclude = []
        widgets = {
            'codename': forms.HiddenInput(),
            'resource_type': forms.HiddenInput(),
            'resource_pk': forms.HiddenInput(),
        }


class AvailabilityParametersForm(forms.ModelForm):
    class Meta:
        model = AvailabilityParameters
        fields = ['run_check', 'notification_delays']
        widgets = {
            'notification_delays': forms.TextInput,
        }


class ImportSiteForm(forms.Form):
    site_json = forms.FileField(label=_('Site Export File'))
    import_users = forms.BooleanField(label=_('Import users and access rights'), required=False)
