# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import passerelle.apps.jsondatastore.models
import jsonfield.fields


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0005_resourcelog'),
    ]

    operations = [
        migrations.CreateModel(
            name='JsonData',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('uuid', models.CharField(default=passerelle.apps.jsondatastore.models.get_hex_uuid, verbose_name='uuid', unique=True, max_length=32, editable=False)),
                ('name_id', models.CharField(max_length=256, blank=True)),
                ('content', jsonfield.fields.JSONField(default=dict, verbose_name='Content')),
                ('creation_datetime', models.DateTimeField(auto_now_add=True)),
                ('last_update_datetime', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='JsonDataStore',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(verbose_name='Title', max_length=50)),
                ('slug', models.SlugField(verbose_name='Identifier', unique=True)),
                ('description', models.TextField(verbose_name='Description')),
                ('log_level', models.CharField(default=b'INFO', max_length=10, verbose_name='Log Level', choices=[(b'NOTSET', b'NOTSET'), (b'DEBUG', b'DEBUG'), (b'INFO', b'INFO'), (b'WARNING', b'WARNING'), (b'ERROR', b'ERROR'), (b'CRITICAL', b'CRITICAL')])),
                ('users', models.ManyToManyField(to='base.ApiUser', related_name='_jsondata_users_+', related_query_name='+', blank=True)),
            ],
            options={
                'verbose_name': 'JSON Data Store',
            },
        ),
    ]
