# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2019-02-15 09:57
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0010_loggingparameters_trace_emails'),
    ]

    operations = [
        migrations.CreateModel(
            name='Link',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_id', models.CharField(max_length=256, verbose_name='NameID')),
                ('file_number', models.CharField(max_length=64, verbose_name='MDPH beneficiary file number')),
                ('secret', models.CharField(max_length=64, verbose_name='MDPH beneficiary secret')),
                ('dob', models.DateField(verbose_name='MDPH beneficiary date of birth')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
            ],
            options={
                'ordering': ['file_number'],
            },
        ),
        migrations.CreateModel(
            name='MDPH13Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.TextField(verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Identifier')),
                ('basic_auth_username', models.CharField(blank=True, max_length=128, verbose_name='Basic authentication username')),
                ('basic_auth_password', models.CharField(blank=True, max_length=128, verbose_name='Basic authentication password')),
                ('client_certificate', models.FileField(blank=True, null=True, upload_to=b'', verbose_name='TLS client certificate')),
                ('trusted_certificate_authorities', models.FileField(blank=True, null=True, upload_to=b'', verbose_name='TLS trusted CAs')),
                ('verify_cert', models.BooleanField(default=True, verbose_name='TLS verify certificates')),
                ('http_proxy', models.CharField(blank=True, max_length=128, verbose_name='HTTP and HTTPS proxy')),
                ('webservice_base_url', models.URLField(verbose_name='Webservice Base URL')),
                ('users', models.ManyToManyField(blank=True, related_name='_link_users_+', related_query_name='+', to='base.ApiUser')),
            ],
            options={
                'verbose_name': 'MDPH CD13',
            },
        ),
        migrations.AddField(
            model_name='link',
            name='resource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mdph13.MDPH13Resource'),
        ),
        migrations.AlterUniqueTogether(
            name='link',
            unique_together=set([('resource', 'name_id', 'file_number')]),
        ),
    ]
