# -*- coding: utf-8 -*-
# passerelle - uniform access to multiple data sources and services
# Copyright (C) 2019 Entr'ouvert
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pytest

from passerelle.utils.sftp import SFTP
from passerelle.apps.sp_fr.models import Resource

import utils


DUMMY_CONTENT = {
    'DILA': {
        'a.zip': 'a',
    }
}


@pytest.fixture
def spfr(settings, wcs_host, db, sftpserver):
    wcs_host.add_api_secret('test', 'test')
    settings.KNOWN_SERVICES = {
        'wcs': {
            'eservices': {
                'title': u'Démarches',
                'url': wcs_host.url,
                'secret': 'test',
                'orig': 'test',
            }
        }
    }
    yield utils.make_resource(
        Resource,
        title='Test 1',
        slug='test1',
        description='Connecteur de test',
        input_sftp=SFTP('sftp://john:doe@{server.host}:{server.port}/DILA/'.format(server=sftpserver)),
        output_sftp=SFTP('sftp://john:doe@{server.host}:{server.port}/DILA/'.format(server=sftpserver))
    )


def test_resource(spfr):
    from passerelle.utils.wcs import get_wcs_choices

    assert [x[1] for x in get_wcs_choices()] == ['---------', u'D\xe9marches - Demande']


def test_sftp_access(spfr, sftpserver):
    with sftpserver.serve_content(DUMMY_CONTENT):
        with spfr.input_sftp.client() as input_sftp:
            assert input_sftp.listdir() == ['a.zip']
        with spfr.output_sftp.client() as output_sftp:
            assert output_sftp.listdir() == ['a.zip']
