import pytest
import mock
import requests
from zeep import Settings
from zeep.plugins import Plugin
from zeep.exceptions import XMLParseError

from passerelle.utils.soap import SOAPClient


WSDL = 'tests/data/soap.wsdl'


class FooPlugin(Plugin):
    pass


class BarPlugin(Plugin):
    pass


class SOAPResource(object):

    def __init__(self):
        self.requests = requests.Session()
        self.wsdl_url = WSDL


def test_soap_client():
    soap_resource = SOAPResource()
    plugins = [FooPlugin, BarPlugin]
    client = SOAPClient(soap_resource, plugins=plugins)
    assert client.wsdl.location.endswith(WSDL)
    assert client.transport.session == soap_resource.requests
    assert client.transport.cache
    assert client.plugins == plugins

@mock.patch('requests.sessions.Session.post')
def test_disable_strict_mode(mocked_post):
    response = requests.Response()
    response.status_code = 200
    response._content = '''<?xml version='1.0' encoding='utf-8'?>
<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/">
  <soap-env:Body>
    <ns0:TradePrice xmlns:ns0="http://example.com/stockquote.xsd">
      <price>4.20</price>
    </ns0:TradePrice>
  </soap-env:Body>
</soap-env:Envelope>'''
    mocked_post.return_value = response

    soap_resource = SOAPResource()
    client = SOAPClient(soap_resource)
    with pytest.raises(
            XMLParseError, match="Unexpected element u'price', expected u'skipMe'"):
        client.service.GetLastTradePrice(tickerSymbol='banana')

    client = SOAPClient(soap_resource, settings=Settings(strict=False))
    result = client.service.GetLastTradePrice(tickerSymbol='banana')
    assert len(result) == 2
    assert result['skipMe'] == None
    assert result['price'] == 4.2
