# -*- coding: utf-8 -*-
import pytest
import mock
import utils
import json

from passerelle.apps.airquality.models import AirQuality

SAMPLE_RESPONSE = '''<?xml version='1.0' ?>
<ATMO>
  <JOUR_ATMO>
    12/05/2017    <VILLE>Indice ATMO de l'agglomération de Lyon</VILLE>
    <TYPE_INDICE>PARTIEL</TYPE_INDICE>
    <COMMENTAIRE>
      <![CDATA[
       Jeudi 11 mai, le temps perturbé a permis d’avoir une bonne qualité de l’air sur la zone de surveillance.
Vendredi 12, la succession d’épisodes pluvio-orageux favorise le maintien de la qualité de l’air qui restera bonne.
Samedi 13, les conditions météorologiques proches de celles de la veille devraient conduire à une bonne qualité de l’air sur l’ensemble du territoire.
       ]]>
    </COMMENTAIRE>
    <MESURE>
      <INDICE>
        <JOUR_INDICE jour="12/05/2017" />
                  <VALEUR>4</VALEUR>
                <SOUS_INDICES>
                      <SOUSINDICE NOM="POUSSIERE">2</SOUSINDICE>
                                          <SOUSINDICE NOM="DIOXYDE D'AZOTE">3</SOUSINDICE>
                                <SOUSINDICE NOM="OZONE">4</SOUSINDICE>
                  </SOUS_INDICES>
      </INDICE>
    </MESURE>
    <PREVISION_J1>
      <INDICE>
        <JOUR_INDICE>13/05/2017</JOUR_INDICE>
                  <VALEUR>4</VALEUR>
              </INDICE>
    </PREVISION_J1>
  </JOUR_ATMO>
</ATMO>
'''

@pytest.fixture
def airquality(db):
    return AirQuality.objects.create(slug='atmo')


def test_airquality_details(app, airquality):
    endpoint = utils.generic_endpoint_url('airquality', 'details', slug=airquality.slug)
    assert endpoint == '/airquality/atmo/details'
    with mock.patch('passerelle.utils.Request.get') as requests_get:
        requests_get.return_value = mock.Mock(content=SAMPLE_RESPONSE, status_code=200)
        resp = app.get(endpoint + '/fr/lyon/', status=200)
        assert resp.json['data']['latest']['value'] == '4'

def test_airquality_details_unknown_city(app, airquality):
    endpoint = utils.generic_endpoint_url('airquality', 'details', slug=airquality.slug)
    resp = app.get(endpoint + '/fr/paris/', status=404)
