import os

LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'UTC'

KNOWN_SERVICES = {
    'wcs': {
        'wcs1': {
            'url': 'http://example.org/',
            'verif_orig': 'wcs1',
            'secret': 'abcde',
        }
    }
}

# include all contrib apps
INSTALLED_APPS += (
    'passerelle.contrib.adict',
    'passerelle.contrib.agoraplus',
    'passerelle.contrib.dpark',
    'passerelle.contrib.fake_family',
    'passerelle.contrib.gdema',
    'passerelle.contrib.grandlyon_streetsections',
    'passerelle.contrib.greco',
    'passerelle.contrib.grenoble_gru',
    'passerelle.contrib.iparapheur',
    'passerelle.contrib.iws',
    'passerelle.contrib.lille_urban_card',
    'passerelle.contrib.maarch',
    'passerelle.contrib.mdph13',
    'passerelle.contrib.meyzieu_newsletters',
    'passerelle.contrib.nancypoll',
    'passerelle.contrib.planitech',
    'passerelle.contrib.seisin_by_email',
    'passerelle.contrib.solis_apa',
    'passerelle.contrib.strasbourg_eu',
    'passerelle.contrib.stub_invoices',
    'passerelle.contrib.teamnet_axel',
    'passerelle.contrib.tlmcom',
    'passerelle.contrib.tcl',
    'passerelle.contrib.toulouse_axel',
    'passerelle.contrib.lille_kimoce',
)

# enable applications that are otherwise disabled
PASSERELLE_APP_BDP_ENABLED = True
PASSERELLE_APP_GDC_ENABLED = True
PASSERELLE_APP_STRASBOURG_EU_ENABLED = True

TCL_URL_TEMPLATE = 'http://tcl.example.net/%s'
TCL_GEOJSON_URL_TEMPLATE = 'http://tcl.example.net/geojson/%s'


CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
    },
    'dummy': {
        'BACKEND': 'django.core.cache.backends.dummy.DummyCache'
    }
}

DATABASES = {
    'default': {
        'ENGINE': os.environ.get('DB_ENGINE', 'django.db.backends.sqlite3'),
        'TEST': {
            'NAME': 'passerelle-test-%s' % os.environ.get("BRANCH_NAME", "").replace('/', '-')[:63],
        },
    }
}

LOGGED_REQUESTS_MAX_SIZE = 4999
